/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WarpScroll
extends ModItem
implements AliasProvider {
    public WarpScroll() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(false)));
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack stack, ItemEntity entity) {
        if (entity.getCommandSenderWorld().isClientSide) {
            return false;
        }
        String displayName = stack.get(DataComponents.CUSTOM_NAME) != null ? stack.getHoverName().getString() : null;
        WarpScrollData data = (WarpScrollData)stack.get(DataComponentRegistry.WARP_SCROLL);
        if (data.isValid() && data.canTeleportWithDim(entity.getCommandSenderWorld().dimension().location().toString()) && SourceUtil.hasSourceNearby(entity.blockPosition(), entity.getCommandSenderWorld(), 10, 9000) && ((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).trySpawnPortal(entity.getCommandSenderWorld(), entity.blockPosition(), data, displayName) && SourceUtil.takeSourceMultipleWithParticles(entity.blockPosition(), entity.getCommandSenderWorld(), 10, 9000) != null) {
            BlockPos pos = entity.blockPosition();
            ServerLevel world = (ServerLevel)entity.getCommandSenderWorld();
            world.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ(), 10, (world.random.nextDouble() - 0.5) * 2.0, -world.random.nextDouble(), (world.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
            world.playSound(null, pos, SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.CREATE_PORTAL.get(), world, pos, 4);
            stack.shrink(1);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        WarpScrollData data = (WarpScrollData)stack.get(DataComponentRegistry.WARP_SCROLL);
        if (hand == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!(world instanceof ServerLevel)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (data.isValid()) {
            if (!data.canTeleportWithDim(player.getCommandSenderWorld().dimension().location().toString())) {
                player.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.warp_scroll.wrong_dim"));
                return InteractionResultHolder.fail((Object)stack);
            }
            BlockPos pos = data.pos().get();
            Vec2 rotation = data.rotation();
            Vec3 vec3 = player.position;
            Networking.sendToNearbyClient(world, (Entity)player, (CustomPacketPayload)new PacketWarpPosition(player.getId(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, rotation.x, rotation.y));
            player.teleportTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            player.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)player));
            player.setXRot(rotation.x);
            player.setYRot(rotation.y);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ(), 10, (world.random.nextDouble() - 0.5) * 2.0, -world.random.nextDouble(), (world.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
            world.playSound(null, pos, SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            boolean didAdd;
            ItemStack newWarpStack = new ItemStack((ItemLike)ItemsRegistry.WARP_SCROLL.get());
            newWarpStack.set(DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(Optional.of(player.blockPosition()), player.getCommandSenderWorld().dimension().location().toString(), player.getRotationVector(), false));
            if (stack.getCount() == 1) {
                stack = newWarpStack;
                didAdd = true;
            } else {
                didAdd = player.addItem(newWarpStack);
                if (didAdd && !player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
            }
            if (!didAdd) {
                player.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.warp_scroll.inv_full"));
                return InteractionResultHolder.fail((Object)stack);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.warp_scroll.recorded"));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        stack.addToTooltip(DataComponentRegistry.WARP_SCROLL, context, tooltip2::add, flagIn);
    }

    @Override
    public Collection<AliasProvider.Alias> getAliases() {
        return List.of(new AliasProvider.Alias("warp_portal", "Warp Portal"));
    }
}

